/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.busmon.parser;

public abstract class DDCCI {
    public static String getCommandName(int n) {
        switch (n & 0xFF) {
            case 1: {
                return "Get VCP Feature";
            }
            case 2: {
                return "VCP Feature Reply";
            }
            case 3: {
                return "Set VCP Feature";
            }
            case 6: {
                return "Timing Message";
            }
            case 7: {
                return "Get Timing Report";
            }
            case 12: {
                return "Save Current Settings";
            }
            case 161: {
                return "Application Test Reply";
            }
            case 177: {
                return "Application Test";
            }
            case 190: {
                return "Null DDC/CI Message";
            }
            case 226: {
                return "Table Read";
            }
            case 227: {
                return "Capabilities Reply";
            }
            case 231: {
                return "Table Write";
            }
            case 243: {
                return "Capabilities Request Command";
            }
        }
        return "Unknown Command " + String.format("%02X", n & 0xFF);
    }

    public static boolean isLegalCommand(int n) {
        switch (n & 0xFF) {
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 12: 
            case 161: 
            case 177: 
            case 190: 
            case 226: 
            case 227: 
            case 231: 
            case 243: {
                return true;
            }
        }
        return false;
    }

    public static String getShortOpcodeName(int n) {
        switch (n & 0xFF) {
            case 32: {
                return "H Pos";
            }
            case 34: {
                return "H Size";
            }
            case 36: {
                return "H Pin";
            }
            case 38: {
                return "H Pin Bal";
            }
            case 40: {
                return "H Conv R/B";
            }
            case 41: {
                return "H Conv M/G";
            }
            case 42: {
                return "H Lin";
            }
            case 44: {
                return "H Lin Bal";
            }
            case 48: {
                return "V Pos";
            }
            case 50: {
                return "V Size";
            }
            case 52: {
                return "V Pin";
            }
            case 54: {
                return "V Pin Bal";
            }
            case 56: {
                return "V Conv R/B";
            }
            case 57: {
                return "V Conv M/G";
            }
            case 58: {
                return "V Lin";
            }
            case 60: {
                return "V Lin Bal";
            }
            case 64: {
                return "H Prlgram";
            }
            case 65: {
                return "V Prlgram";
            }
            case 66: {
                return "H Key";
            }
            case 67: {
                return "V Key";
            }
            case 68: {
                return "Rotation";
            }
            case 70: {
                return "Top Cnr Flare";
            }
            case 72: {
                return "Top Cnr Hook";
            }
            case 74: {
                return "Bot Cnr Flare";
            }
            case 76: {
                return "Bot Cnr Hook";
            }
            case 130: {
                return "H Mirror";
            }
            case 132: {
                return "V Mirror";
            }
            case 134: {
                return "Disp Scale";
            }
            case 149: {
                return "Win Pos (TL_X)";
            }
            case 150: {
                return "Win Pos (TL_Y)";
            }
            case 151: {
                return "Win Pos (BR_X)";
            }
            case 152: {
                return "Win Pos (BR_Y)";
            }
            case 218: {
                return "Scan Mode";
            }
            case 4: {
                return "Rst Fac Def";
            }
            case 5: {
                return "Rst Fac Lum/Con";
            }
            case 6: {
                return "Rst Fac Geom";
            }
            case 8: {
                return "Rst Fac Color";
            }
            case 10: {
                return "Rst Fac TV";
            }
            case 176: {
                return "Settings";
            }
            case 11: {
                return "Clr Temp Inc";
            }
            case 12: {
                return "Clr Temp Req";
            }
            case 14: {
                return "Clock";
            }
            case 16: {
                return "Luminance";
            }
            case 17: {
                return "Flesh Tone Enh";
            }
            case 18: {
                return "Contrast";
            }
            case 19: {
                return "Backlt Ctrl";
            }
            case 20: {
                return "Sel Clr Preset";
            }
            case 22: {
                return "RED Video Gain";
            }
            case 23: {
                return "Clr Vis Comp";
            }
            case 24: {
                return "GRN Video Gain";
            }
            case 26: {
                return "BLU Video Gain";
            }
            case 28: {
                return "Focus";
            }
            case 30: {
                return "Auto Setup";
            }
            case 31: {
                return "Auto Clr Setup";
            }
            case 46: {
                return "Gray Scale Exp";
            }
            case 62: {
                return "Clock Phase";
            }
            case 86: {
                return "H Moire";
            }
            case 88: {
                return "V Moire";
            }
            case 89: {
                return "6 Axis Sat RED";
            }
            case 90: {
                return "6 Axis Sat YEL";
            }
            case 91: {
                return "6 Axis Sat GRN";
            }
            case 92: {
                return "6 Axis Sat CYN";
            }
            case 93: {
                return "6 Axis Sat BLU";
            }
            case 94: {
                return "6 Axis Sat MAG";
            }
            case 108: {
                return "RED Vid Blk Lvl";
            }
            case 110: {
                return "GRN Vid Blk Lvl";
            }
            case 112: {
                return "BLU Vid Blk Lvl";
            }
            case 114: {
                return "Gamma";
            }
            case 115: {
                return "LUT Size";
            }
            case 116: {
                return "Point LUT Op";
            }
            case 117: {
                return "Block LUT Op";
            }
            case 124: {
                return "Adjust Zoom";
            }
            case 135: {
                return "Sharpness";
            }
            case 136: {
                return "Vel Scan Mod";
            }
            case 138: {
                return "Color Sat";
            }
            case 140: {
                return "TV-Sharpness";
            }
            case 142: {
                return "TV-Contrast";
            }
            case 144: {
                return "Hue";
            }
            case 146: {
                return "TV-Blk Lvl/Lum";
            }
            case 154: {
                return "Win Bkgrd";
            }
            case 155: {
                return "6 Axis Hue RED";
            }
            case 156: {
                return "6 Axis Hue YLW";
            }
            case 157: {
                return "6 Axis Hue GRN";
            }
            case 158: {
                return "6 Axis Hue CYN";
            }
            case 159: {
                return "6 Axis Hue BLU";
            }
            case 160: {
                return "6 Axis Hue MAG";
            }
            case 162: {
                return "Auto Setup";
            }
            case 164: {
                return "Window Ctrl";
            }
            case 165: {
                return "Window Sel";
            }
            case 170: {
                return "Screen Orient";
            }
            case 212: {
                return "Stereo Video";
            }
            case 220: {
                return "Display App";
            }
            case 98: {
                return "Audio: Spk Vol";
            }
            case 100: {
                return "Audio: Mic Vol";
            }
            case 141: {
                return "Audio Mute";
            }
            case 143: {
                return "Audio Treble";
            }
            case 145: {
                return "Audio Bass";
            }
            case 147: {
                return "Audio Bal L/R";
            }
            case 148: {
                return "Audio: St Mode";
            }
            case 172: {
                return "H Freq";
            }
            case 174: {
                return "V Freq";
            }
            case 192: {
                return "Disp Usage Time";
            }
            case 200: {
                return "Disp Ctrlr Type";
            }
            case 201: {
                return "Disp FW Lvl";
            }
            case 202: {
                return "OSD";
            }
            case 204: {
                return "OSD Lang";
            }
            case 214: {
                return "Power Mode";
            }
            case 223: {
                return "VCP Vers";
            }
            case 183: {
                return "DPVL Mon Status";
            }
            case 184: {
                return "DPVL Pkt Count";
            }
            case 185: {
                return "DPVL Mon X Org";
            }
            case 186: {
                return "DPVL Mon Y Org";
            }
            case 187: {
                return "DPVL Hdr Err Cnt";
            }
            case 188: {
                return "DPVL Body CRC Err Cnt";
            }
            case 189: {
                return "DPVL Client ID";
            }
            case 190: {
                return "DPVL Link Ctrl";
            }
            case 1: {
                return "Degauss";
            }
            case 2: {
                return "New Ctrl Value";
            }
            case 3: {
                return "Soft Ctrls";
            }
            case 82: {
                return "Actv Ctrl";
            }
            case 84: {
                return "Perf Presvn";
            }
            case 96: {
                return "Input Src";
            }
            case 102: {
                return "Amb Light Sensor";
            }
            case 118: {
                return "RPC";
            }
            case 120: {
                return "EDID Op";
            }
            case 139: {
                return "TV-Channel";
            }
            case 178: {
                return "Flat Pnl Subpxl Layout";
            }
            case 182: {
                return "Disp Tech Type";
            }
            case 194: {
                return "Disp Descr Len";
            }
            case 195: {
                return "Xmit Disp Descr";
            }
            case 196: {
                return "Display 'Disp Descr'";
            }
            case 198: {
                return "App Ena Key";
            }
            case 199: {
                return "Disp Ena Key";
            }
            case 205: {
                return "Status Ind";
            }
            case 206: {
                return "Aux Disp Size";
            }
            case 207: {
                return "Aux Disp Data";
            }
            case 208: {
                return "Output Sel";
            }
            case 215: {
                return "Aux Pwr Output";
            }
            case 222: {
                return "Op Mode";
            }
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 238: 
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 250: 
            case 251: 
            case 252: 
            case 253: 
            case 254: 
            case 255: {
                return "Mfr Opcode " + String.format("%02X", n & 0xFF);
            }
        }
        return "Unk Opcode " + String.format("%02X", n & 0xFF);
    }

    public static String getOpcodeName(int n) {
        switch (n & 0xFF) {
            case 32: {
                return "Horizontal Position (Phase)";
            }
            case 34: {
                return "Horizontal Size";
            }
            case 36: {
                return "Horizontal Pincushion";
            }
            case 38: {
                return "Horizontal Pincushion Balance";
            }
            case 40: {
                return "Horizontal Convergence R/B";
            }
            case 41: {
                return "Horizontal Convergence M/G";
            }
            case 42: {
                return "Horizontal Linearity";
            }
            case 44: {
                return "Horizontal Linearity Balance";
            }
            case 48: {
                return "Vertical Position (Phase)";
            }
            case 50: {
                return "Vertical Size";
            }
            case 52: {
                return "Vertical Pincushion";
            }
            case 54: {
                return "Vertical Pincushion Balance";
            }
            case 56: {
                return "Vertical Convergence R/B";
            }
            case 57: {
                return "Vertical Convergence M/G";
            }
            case 58: {
                return "Vertical Linearity";
            }
            case 60: {
                return "Vertical Linearity Balance";
            }
            case 64: {
                return "Horizontal Parallelogram";
            }
            case 65: {
                return "Vertical Parallelogram";
            }
            case 66: {
                return "Horizontal Keystone";
            }
            case 67: {
                return "Vertical Keystone";
            }
            case 68: {
                return "Rotation";
            }
            case 70: {
                return "Top Corner Flare";
            }
            case 72: {
                return "Top Corner Hook";
            }
            case 74: {
                return "Bottom Corner Flare";
            }
            case 76: {
                return "Bottom Corner Hook";
            }
            case 130: {
                return "Horizontal Mirror (Flip)";
            }
            case 132: {
                return "Vertical Mirror (Flip)";
            }
            case 134: {
                return "Display Scaling";
            }
            case 149: {
                return "Window Position (TL_X)";
            }
            case 150: {
                return "Window Position (TL_Y)";
            }
            case 151: {
                return "Window Position (BR_X)";
            }
            case 152: {
                return "Window Position (BR_Y)";
            }
            case 218: {
                return "Scan Mode";
            }
            case 4: {
                return "Restore Factory Defaults";
            }
            case 5: {
                return "Restore Factory Luminance/Contrast Defaults";
            }
            case 6: {
                return "Restore Factory Geometry Defaults";
            }
            case 8: {
                return "Restore Factory Color Defaults";
            }
            case 10: {
                return "Restore Factory TV Defaults";
            }
            case 176: {
                return "Settings";
            }
            case 11: {
                return "Color Temperature Increment";
            }
            case 12: {
                return "Color Temperature Request";
            }
            case 14: {
                return "Clock";
            }
            case 16: {
                return "Luminance";
            }
            case 17: {
                return "Flesh Tone Enhancement";
            }
            case 18: {
                return "Contrast";
            }
            case 19: {
                return "Backlight Control";
            }
            case 20: {
                return "Select Color Preset";
            }
            case 22: {
                return "Red Video Gain (Drive)";
            }
            case 23: {
                return "User Color Vision Compensation";
            }
            case 24: {
                return "Green Video Gain (Drive)";
            }
            case 26: {
                return "Blue Video Gain (Drive)";
            }
            case 28: {
                return "Focus";
            }
            case 30: {
                return "Auto Setup";
            }
            case 31: {
                return "Auto Color Setup";
            }
            case 46: {
                return "Gray Scale Expansion";
            }
            case 62: {
                return "Clock Phase";
            }
            case 86: {
                return "Horizontal Moire";
            }
            case 88: {
                return "Vertical Moire";
            }
            case 89: {
                return "6 Axis Saturation Control: Red";
            }
            case 90: {
                return "6 Axis Saturation Control: Yellow";
            }
            case 91: {
                return "6 Axis Saturation Control: Green";
            }
            case 92: {
                return "6 Axis Saturation Control: Cyan";
            }
            case 93: {
                return "6 Axis Saturation Control: Blue";
            }
            case 94: {
                return "6 Axis Saturation Control: Magenta";
            }
            case 108: {
                return "Red Video Black Level";
            }
            case 110: {
                return "Green Video Black Level";
            }
            case 112: {
                return "Blue Video Black Level";
            }
            case 114: {
                return "Gamma";
            }
            case 115: {
                return "LUT Size";
            }
            case 116: {
                return "Single Point LUT Operation";
            }
            case 117: {
                return "Block LUT Operation";
            }
            case 124: {
                return "Adjust Zoom";
            }
            case 135: {
                return "Sharpness";
            }
            case 136: {
                return "Velocity Scan Modulation";
            }
            case 138: {
                return "Color Saturation";
            }
            case 140: {
                return "TV-Sharpness";
            }
            case 142: {
                return "TV-Contrast";
            }
            case 144: {
                return "Hue";
            }
            case 146: {
                return "TV-Black Level/Luminance";
            }
            case 154: {
                return "Window Background";
            }
            case 155: {
                return "6 Axis Hue Control: Red";
            }
            case 156: {
                return "6 Axis Hue Control: Yellow";
            }
            case 157: {
                return "6 Axis Hue Control: Green";
            }
            case 158: {
                return "6 Axis Hue Control: Cyan";
            }
            case 159: {
                return "6 Axis Hue Control: Blue";
            }
            case 160: {
                return "6 Axis Hue Control: Magenta";
            }
            case 162: {
                return "Auto Setup On / Off";
            }
            case 164: {
                return "Window Control On / Off";
            }
            case 165: {
                return "Window Select";
            }
            case 170: {
                return "Screen Orientation";
            }
            case 212: {
                return "Stereo Video Mode";
            }
            case 220: {
                return "Display Application";
            }
            case 98: {
                return "Audio: Speaker Volume";
            }
            case 100: {
                return "Audio: Microphone Volume";
            }
            case 141: {
                return "Audio Mute";
            }
            case 143: {
                return "Audio Treble";
            }
            case 145: {
                return "Audio Bass";
            }
            case 147: {
                return "Audio Balance L/R";
            }
            case 148: {
                return "Audio: Stereo Mode";
            }
            case 172: {
                return "Horizontal Frequency";
            }
            case 174: {
                return "Vertical Frequency";
            }
            case 192: {
                return "Display Usage Time";
            }
            case 200: {
                return "Display Controller Type";
            }
            case 201: {
                return "Display Firmware Level";
            }
            case 202: {
                return "OSD";
            }
            case 204: {
                return "OSD Language";
            }
            case 214: {
                return "Power Mode";
            }
            case 223: {
                return "VCP Version";
            }
            case 183: {
                return "DPVL Monitor Status";
            }
            case 184: {
                return "DPVL Packet Count";
            }
            case 185: {
                return "DPVL Monitor X Origin";
            }
            case 186: {
                return "DPVL Monitor Y Origin";
            }
            case 187: {
                return "DPVL Header Error Count";
            }
            case 188: {
                return "DPVL Body CRC Error Count";
            }
            case 189: {
                return "DPVL Client ID";
            }
            case 190: {
                return "DPVL Link Control";
            }
            case 1: {
                return "Degauss";
            }
            case 2: {
                return "New Control Value";
            }
            case 3: {
                return "Soft Controls";
            }
            case 82: {
                return "Active Control";
            }
            case 84: {
                return "Performance Preservation";
            }
            case 96: {
                return "Input Source";
            }
            case 102: {
                return "Ambient Light Sensor";
            }
            case 118: {
                return "Remote Procedure Call";
            }
            case 120: {
                return "EDID Operation";
            }
            case 139: {
                return "TV-Channel Up/Down";
            }
            case 178: {
                return "Flat Panel Sub-Pixel Layout";
            }
            case 182: {
                return "Display Technology Type";
            }
            case 194: {
                return "Display Descriptor Length";
            }
            case 195: {
                return "Transmit Display Descriptor";
            }
            case 196: {
                return "Enable Display of 'Display Descriptor'";
            }
            case 198: {
                return "Application Enable Key";
            }
            case 199: {
                return "Display Enable Key";
            }
            case 205: {
                return "Status Indicators";
            }
            case 206: {
                return "Auxiliary Display Size";
            }
            case 207: {
                return "Auxiliary Display Data";
            }
            case 208: {
                return "Output Select";
            }
            case 215: {
                return "Auxiliary Power Output";
            }
            case 222: {
                return "Operation Mode";
            }
        }
        if ((n & 0xFF) >= 224) {
            return "Manufacturer Specific Opcode " + String.format("%02X", n & 0xFF);
        }
        return "Unknown Opcode " + String.format("%02X", n & 0xFF);
    }

    public static String getArgumentString(int n, int n2) {
        int n3 = n2 >> 8 & 0xFF;
        int n4 = n2 & 0xFF;
        int n5 = n2;
        switch (n) {
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 120: 
            case 195: 
            case 207: {
                return "(TABLE READ)";
            }
            case 130: {
                switch (n3) {
                    case 0: {
                        return "Normal";
                    }
                    case 1: {
                        return "Mirrored";
                    }
                }
                return "Reserved";
            }
            case 132: {
                switch (n3) {
                    case 0: {
                        return "Normal";
                    }
                    case 1: {
                        return "Mirrored";
                    }
                }
                return "Reserved";
            }
            case 134: {
                switch (n3) {
                    case 1: {
                        return "No scaling";
                    }
                    case 2: {
                        return "Max Image";
                    }
                    case 3: {
                        return "Max Vt 1";
                    }
                    case 4: {
                        return "Max Hz 1";
                    }
                    case 5: {
                        return "Max Vt 2";
                    }
                    case 6: {
                        return "Max Hz 2";
                    }
                    case 7: {
                        return "Full mode";
                    }
                    case 8: {
                        return "Zoom mode";
                    }
                    case 9: {
                        return "Squeeze mode";
                    }
                    case 10: {
                        return "Variable";
                    }
                }
                return "Reserved";
            }
            case 218: {
                switch (n3) {
                    case 0: {
                        return "Normal";
                    }
                    case 1: {
                        return "Underscan";
                    }
                    case 2: {
                        return "Overscan";
                    }
                }
                return "Reserved";
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                return n3 == 0 ? "Ignore" : "Execute";
            }
            case 176: {
                switch (n3) {
                    case 1: {
                        return "Store";
                    }
                    case 2: {
                        return "Restore";
                    }
                }
                return "Reserved";
            }
            case 11: {
                if (n5 == 0 || n5 > 5000) {
                    return "Invalid Value " + n2;
                }
                return String.format("%d K", n2);
            }
            case 17: {
                switch (n3) {
                    case 0: {
                        return "Off";
                    }
                    case 1: {
                        return "Enhancement 1";
                    }
                    case 2: {
                        return "Enhancement 2";
                    }
                    case 3: {
                        return "Demo Mode";
                    }
                    case 4: {
                        return "User Mode";
                    }
                }
                return "Reserved";
            }
            case 20: {
                String string;
                switch (n3) {
                    case 0: {
                        string = "Relative Scale";
                    }
                    case 1: {
                        string = "1% Tolerance";
                    }
                    case 2: {
                        string = "2% Tolerance";
                    }
                    case 3: {
                        string = "3% Tolerance";
                    }
                    case 4: {
                        string = "4% Tolerance";
                    }
                    case 5: {
                        string = "5% Tolerance";
                    }
                    case 6: {
                        string = "6% Tolerance";
                    }
                    case 7: {
                        string = "7% Tolerance";
                    }
                    case 8: {
                        string = "8% Tolerance";
                    }
                    case 9: {
                        string = "9% Tolerance";
                    }
                    case 10: {
                        string = "10% Tolerance";
                    }
                }
                string = "Invalid Tolerance " + n3;
                if (n3 == 0) {
                    switch (n4) {
                        case 1: {
                            string = string + ", sRGB";
                            break;
                        }
                        case 2: {
                            string = string + ", Display Native";
                            break;
                        }
                        case 3: {
                            string = string + ", Warm |#-------| Cool";
                            break;
                        }
                        case 4: {
                            string = string + ", Warm |-#------| Cool";
                            break;
                        }
                        case 5: {
                            string = string + ", Warm |--#-----| Cool";
                            break;
                        }
                        case 6: {
                            string = string + ", Warm |---#----| Cool";
                            break;
                        }
                        case 7: {
                            string = string + ", Warm |----#---| Cool";
                            break;
                        }
                        case 8: {
                            string = string + ", Warm |-----#--| Cool";
                            break;
                        }
                        case 9: {
                            string = string + ", Warm |------#-| Cool";
                            break;
                        }
                        case 10: {
                            string = string + ", Warm |-------#| Cool";
                            break;
                        }
                        case 11: {
                            string = string + ", User 1";
                            break;
                        }
                        case 12: {
                            string = string + ", User 2";
                            break;
                        }
                        case 13: {
                            string = string + ", User 3";
                            break;
                        }
                    }
                } else {
                    switch (n4) {
                        case 1: {
                            string = string + ", sRGB";
                            break;
                        }
                        case 2: {
                            string = string + ", Display Native";
                            break;
                        }
                        case 3: {
                            string = string + ", 4000 K";
                            break;
                        }
                        case 4: {
                            string = string + ", 5000 K";
                            break;
                        }
                        case 5: {
                            string = string + ", 6500 K";
                            break;
                        }
                        case 6: {
                            string = string + ", 7500 K";
                            break;
                        }
                        case 7: {
                            string = string + ", 8200 K";
                            break;
                        }
                        case 8: {
                            string = string + ", 9300 K";
                            break;
                        }
                        case 9: {
                            string = string + ", 10000 K";
                            break;
                        }
                        case 10: {
                            string = string + ", 11500 K";
                            break;
                        }
                        case 11: {
                            string = string + ", User 1";
                            break;
                        }
                        case 12: {
                            string = string + ", User 2";
                            break;
                        }
                        case 13: {
                            string = string + ", User 3";
                            break;
                        }
                    }
                }
                return string;
            }
            case 30: 
            case 31: {
                switch (n3) {
                    case 0: {
                        return "Inactive";
                    }
                    case 1: {
                        return "Perform / In Progress";
                    }
                    case 2: {
                        return "Periodic / Continuous";
                    }
                }
                return "Reserved";
            }
            case 46: {
                String string;
                switch (n3) {
                    case 0: {
                        string = "No white region expansion";
                        break;
                    }
                    case 1: {
                        string = "1st Level white expansion";
                        break;
                    }
                    case 2: {
                        string = "2nd Level white expansion";
                        break;
                    }
                    case 3: {
                        string = "3rd Level white expansion";
                        break;
                    }
                    default: {
                        string = "Invalid white expansion level " + n3;
                    }
                }
                switch (n4) {
                    case 16: {
                        string = string + ", No black region expansion";
                        break;
                    }
                    case 17: {
                        string = string + ", 1st Level black expansion";
                        break;
                    }
                    case 18: {
                        string = string + ", 2nd Level black expansion";
                        break;
                    }
                    case 19: {
                        string = string + ", 3rd Level black expansion";
                        break;
                    }
                    default: {
                        string = string + ", Invalid black expansion level " + n4;
                    }
                }
                return string;
            }
            case 114: {
                String string;
                switch (n3) {
                    case 0: {
                        string = "Set White Gamma to ";
                        break;
                    }
                    case 1: {
                        string = "Set Red Gamma to ";
                        break;
                    }
                    case 2: {
                        string = "Set Green Gamma to ";
                        break;
                    }
                    case 3: {
                        string = "Set Blue Gamma to ";
                        break;
                    }
                    case 4: {
                        string = "Adjust White Gamma by ";
                        break;
                    }
                    case 5: {
                        String string2 = "Disable Gamma Correction";
                        return string2;
                    }
                    default: {
                        String string3 = "Invalid High Byte " + n3;
                        return string3;
                    }
                }
                if (n3 == 4) {
                    switch (n4) {
                        case 0: {
                            string = string + "0 (no change)";
                            break;
                        }
                        case 1: {
                            string = string + "-0.1";
                            break;
                        }
                        case 2: {
                            string = string + "-0.2";
                            break;
                        }
                        case 3: {
                            string = string + "-0.3";
                            break;
                        }
                        case 4: {
                            string = string + "-0.4";
                            break;
                        }
                        case 5: {
                            string = string + "-0.5";
                            break;
                        }
                        case 6: {
                            string = string + "-0.6";
                            break;
                        }
                        case 7: {
                            string = string + "-0.7";
                            break;
                        }
                        case 8: {
                            string = string + "-0.8";
                            break;
                        }
                        case 9: {
                            string = string + "-0.9";
                            break;
                        }
                        case 10: {
                            string = string + "-1.0";
                            break;
                        }
                        case 17: {
                            string = string + "+0.1";
                            break;
                        }
                        case 18: {
                            string = string + "+0.2";
                            break;
                        }
                        case 19: {
                            string = string + "+0.3";
                            break;
                        }
                        case 20: {
                            string = string + "+0.4";
                            break;
                        }
                        case 21: {
                            string = string + "+0.5";
                            break;
                        }
                        case 22: {
                            string = string + "+0.6";
                            break;
                        }
                        case 23: {
                            string = string + "+0.7";
                            break;
                        }
                        case 24: {
                            string = string + "+0.8";
                            break;
                        }
                        case 25: {
                            string = string + "+0.9";
                            break;
                        }
                        case 26: {
                            string = string + "+1.0";
                            break;
                        }
                        case 32: {
                            string = "Disable Gamma Correction";
                            break;
                        }
                        default: {
                            string = string + "Invalid Low Byte " + n4;
                        }
                    }
                    return string;
                }
                return String.format("%1.2d", Float.valueOf((float)(n4 / 100) + 1.0f));
            }
            case 162: {
                switch (n3) {
                    case 1: {
                        return "Off";
                    }
                    case 2: {
                        return "On";
                    }
                }
                return "Reserved";
            }
            case 164: {
                return String.format("%08b", n2);
            }
            case 165: {
                if (n3 == 0) {
                    return "Full Display";
                }
                return String.format("Window %d", n3);
            }
            case 170: {
                switch (n3) {
                    case 1: {
                        return "0 degrees";
                    }
                    case 2: {
                        return "90 degrees";
                    }
                    case 3: {
                        return "180 degrees";
                    }
                    case 4: {
                        return "270 degrees";
                    }
                    case 255: {
                        return "Unsupported";
                    }
                }
                return "Reserved";
            }
            case 212: {
                return String.format("%08b", n2);
            }
            case 220: {
                switch (n3) {
                    case 0: {
                        return "Standard";
                    }
                    case 1: {
                        return "Productivity";
                    }
                    case 2: {
                        return "Mixed";
                    }
                    case 3: {
                        return "Movie";
                    }
                    case 4: {
                        return "User Defined";
                    }
                    case 5: {
                        return "Games";
                    }
                    case 6: {
                        return "Sports";
                    }
                    case 7: {
                        return "Professional";
                    }
                    case 8: {
                        return "Standard with intermediate power consumption";
                    }
                    case 9: {
                        return "Standard with low power consumption";
                    }
                    case 16: {
                        return "Demonstration";
                    }
                }
                return "Reserved";
            }
            case 141: {
                switch (n3) {
                    case 1: {
                        return "Mute";
                    }
                    case 2: {
                        return "Unmute";
                    }
                }
                return "Reserved";
            }
            case 148: {
                switch (n3) {
                    case 0: {
                        return "Speaker Off";
                    }
                    case 1: {
                        return "Mono";
                    }
                    case 2: {
                        return "Stereo";
                    }
                    case 3: {
                        return "Stereo expanded";
                    }
                }
                return "Reserved";
            }
            case 200: {
                switch (n3) {
                    case 1: {
                        return "Conexant";
                    }
                    case 2: {
                        return "Genesis Microchip";
                    }
                    case 3: {
                        return "Macronix";
                    }
                    case 4: {
                        return "MRT (Media Reality Technologies)";
                    }
                    case 5: {
                        return "Mstar Semiconductor";
                    }
                    case 6: {
                        return "Myson";
                    }
                    case 7: {
                        return "Philips";
                    }
                    case 8: {
                        return "PixelWorks";
                    }
                    case 9: {
                        return "RealTek Semiconductor";
                    }
                    case 10: {
                        return "Sage";
                    }
                    case 11: {
                        return "Silicon Image";
                    }
                    case 12: {
                        return "SmartASIC";
                    }
                    case 13: {
                        return "STMicroelectronics";
                    }
                    case 14: {
                        return "Topro";
                    }
                    case 15: {
                        return "Trumpion";
                    }
                    case 16: {
                        return "Welltrend";
                    }
                    case 17: {
                        return "Samsung";
                    }
                    case 18: {
                        return "Novatek Microelectronics";
                    }
                    case 19: {
                        return "STK";
                    }
                    case 255: {
                        return "Manufacturer designed";
                    }
                }
                return "Reserved";
            }
            case 202: {
                switch (n3) {
                    case 1: {
                        return "Enabled";
                    }
                    case 2: {
                        return "Disabled";
                    }
                    case -1: {
                        return "Not supported by display";
                    }
                }
                return "Reserved";
            }
            case 204: {
                switch (n3) {
                    case 0: {
                        return "No effect";
                    }
                    case 1: {
                        return "Chinese";
                    }
                    case 2: {
                        return "English";
                    }
                    case 3: {
                        return "French";
                    }
                    case 4: {
                        return "German";
                    }
                    case 5: {
                        return "Italian";
                    }
                    case 6: {
                        return "Japanese";
                    }
                    case 7: {
                        return "Korean";
                    }
                    case 8: {
                        return "Portuguese";
                    }
                    case 9: {
                        return "Russian";
                    }
                    case 16: {
                        return "Spanish";
                    }
                }
                return "Reserved";
            }
            case 214: {
                switch (n3) {
                    case 1: {
                        return "DPM ON, DPMS ON";
                    }
                    case 2: {
                        return "DPM Off, DPMS Standby";
                    }
                    case 3: {
                        return "DPM Off, DPMS Suspend";
                    }
                    case 4: {
                        return "DPM Off, DPMS Off";
                    }
                    case 5: {
                        return "Power Off";
                    }
                }
                return "Reserved";
            }
            case 223: {
                return String.format("Version %d, Revision %d", n3, n4);
            }
            case 183: {
                String string = (n3 & 1) != 0 ? "Raster scan mode" : "DPVL mode";
                string = (n3 & 2) != 0 ? string + ", ready to recieve next packet" : string + ", not ready to accept next packet";
                string = (n3 & 4) != 0 ? string + ", last header had no errors" : string + ", last header contained an error";
                return string;
            }
            case 190: {
                String string = (n3 & 1) != 0 ? "Link shutdown is disabled" : "Link shutdown is enabled";
                return string;
            }
            case 1: {
                return n3 == 0 ? "Ignore" : "Perform Cycle";
            }
            default: {
                return String.format("%d", n2);
            }
            case 2: {
                switch (n3) {
                    case 1: {
                        return "No new control value";
                    }
                    case 2: {
                        return "New control value saved";
                    }
                    case 255: {
                        return "No user controls present";
                    }
                }
                return "Reserved";
            }
            case 3: {
                switch (n3) {
                    case 0: {
                        return "No button active";
                    }
                    case 1: {
                        return "Button 1 active";
                    }
                    case 2: {
                        return "Button 2 active";
                    }
                    case 3: {
                        return "Button 3 active";
                    }
                    case 4: {
                        return "Button 4 active";
                    }
                    case 5: {
                        return "Button 5 active";
                    }
                    case 6: {
                        return "Button 6 active";
                    }
                    case 7: {
                        return "Button 7 active";
                    }
                    case 255: {
                        return "No controls present";
                    }
                }
                return "Reserved";
            }
            case 82: {
                return DDCCI.getOpcodeName(n3);
            }
            case 84: {
                return "(bitfield not implemented in this version)";
            }
            case 96: 
            case 208: {
                switch (n3) {
                    case 1: {
                        return "RGB 1";
                    }
                    case 2: {
                        return "RGB 2";
                    }
                    case 3: {
                        return "TMDS 1";
                    }
                    case 4: {
                        return "TMDS 2";
                    }
                    case 5: {
                        return "Composite 1";
                    }
                    case 6: {
                        return "Composite 2";
                    }
                    case 7: {
                        return "S-Video 1";
                    }
                    case 8: {
                        return "S-Video 2";
                    }
                    case 9: {
                        return "Tuner 1";
                    }
                    case 10: {
                        return "Tuner 2";
                    }
                    case 11: {
                        return "Tuner 3";
                    }
                    case 12: {
                        return "Component 1";
                    }
                    case 13: {
                        return "Component 2";
                    }
                    case 14: {
                        return "Component 3";
                    }
                }
                return "Reserved";
            }
            case 102: {
                switch (n3) {
                    case 1: {
                        return "Disabled";
                    }
                    case 2: {
                        return "Enabled";
                    }
                }
                return "Reserved";
            }
            case 139: {
                switch (n3) {
                    case 1: {
                        return "Increment";
                    }
                    case 2: {
                        return "Decrement";
                    }
                }
                return "Reserved";
            }
            case 178: {
                switch (n3) {
                    case 0: {
                        return "Not Defined";
                    }
                    case 1: {
                        return "RGB Vertical Stripe";
                    }
                    case 2: {
                        return "RGB Horizontal Stripe";
                    }
                    case 3: {
                        return "BGR Vertical Stripe";
                    }
                    case 4: {
                        return "BGR Horizontal Stripe";
                    }
                    case 5: {
                        return "Quad-pixel: Top RG, Bottom GB";
                    }
                    case 6: {
                        return "Quad-pixel: Top GB, Bottom RG";
                    }
                    case 7: {
                        return "Delta";
                    }
                    case 8: {
                        return "Mosaic";
                    }
                }
                return "Reserved";
            }
            case 182: {
                switch (n3) {
                    case 1: {
                        return "CRT (shadow mask)";
                    }
                    case 2: {
                        return "CRT (aperture grill)";
                    }
                    case 3: {
                        return "TFT";
                    }
                    case 4: {
                        return "LCoS";
                    }
                    case 5: {
                        return "Plasma";
                    }
                    case 6: {
                        return "OLED";
                    }
                    case 7: {
                        return "EL";
                    }
                    case 8: {
                        return "MEM";
                    }
                    case 9: {
                        return "FED";
                    }
                }
                return "Reserved";
            }
            case 196: {
                return n3 == 1 ? "Enabled" : "Disabled";
            }
            case 198: {
                return String.format("%X", n5);
            }
            case 199: {
                return String.format("%X", n5);
            }
            case 205: {
                return "(bitfield not implemented in this version)";
            }
            case 206: {
                return "(display size not implemented in this version)";
            }
            case 215: {
                switch (n3) {
                    case 1: {
                        return "Disable";
                    }
                    case 2: {
                        return "Enable";
                    }
                }
                return "Reserved";
            }
            case 222: 
        }
        switch (n3) {
            case 1: {
                return "Stand-alone";
            }
            case 2: {
                return "Slave";
            }
        }
        return "Reserved";
    }
}

